/******************************************************************************/
/*  Program demonstrating usage of SFX DATA format. This sample file converts */
/*  PCX pictures to .DMP SFX DATA format, used by VIEWDMP.EXE.                */
/*  Program was compiled by TC++ 1.0, but there should be no problems with    */
/*  other compilers supporting assembler inserts. It works only on VGA and is */
/*  completely not error proof. Modifying allowed. Part of ELITE package.     */
/******************************************************************************/
#include<conio.h>
#include<stdio.h>
#include<dos.h>
#include<string.h>
#include<process.h>

FILE *Inp,*Out;

#pragma inline

t_init_13h()      /* init 13h mode */
{
asm mov ax,0013h
asm int 10h
return 0;
};

t_close_13h()    /* close 13h mode */
{
asm mov ax,0003h
asm int 10h
return 0;
};

t_clrscr(char color)       /* clear screen routine */
{
asm{
   push es
   push di
   mov ax,0a000h
   mov es,ax
   xor di,di
   mov cx,32000
   mov al,color
   mov ah,color
   rep stosw
   pop di
   pop es
   }
return 0;
}    


char paleta[768];

ustaw_palete(FILE *Inp_pcx)       /* set palette */
{
int R,G,B,count=0;
char color=0;


asm{
   mov dx,3c8h
   mov al,0ffh
   out dx,al
   }

fseek(Inp_pcx,-768,SEEK_END);
while(count<768)
  {
  paleta[count]=(char)fgetc(Inp_pcx);
  count++;
  }
count=0;

while(count<768)
 {
 R=paleta[count];
 G=paleta[count+1];
 B=paleta[count+2];
 asm{
     mov dx,3c8h
     mov al,color
     out dx,al
     inc dx

     mov al,R
     shr al,1
     shr al,1
     out dx,al

     mov al,G
     shr al,1
     shr al,1
     out dx,al

     mov al,B
     shr al,1
     shr al,1
     out dx,al
     }


 count+=3;
 color++;
 }

rewind(Inp_pcx);
return 0;
}

	
load_pcx(FILE *Inp_pcx)
{	
unsigned int torf=0;
char znak,war,ile_razy;

fseek(Inp_pcx,128,SEEK_SET);
while(torf < 64000)
   {
   znak=fgetc(Inp_pcx);
   asm{
       mov ah,znak
       and ah,0c0h
       cmp ah,0c0h
       je marker
       jmp nie_marker
       }
   marker:
   asm{
       mov ah,znak
       and ah,3fh
       mov ile_razy,ah
       }
   war=fgetc(Inp_pcx);
   while(ile_razy-->0)
     {
     pokeb(0xa000,torf,war);
     torf++;
     }
   asm jmp koniec

   nie_marker:
   pokeb(0xa000,torf,znak);
   torf++;
   koniec:
   asm nop
   }
fwrite(MK_FP(0xa000,0),1,0xffff,Out);

return 0;
}



char filename[13];
char extension[4] = {'D','M','P',0};

main(argc,argv)
int argc;
char *argv[];
/// !!! VGA CARD REQUIRED !!!!

{
printf("\n\rONLY 320x200x256 FORMAT FILES\n\r");
if(argc<2)
   {
   printf("    USAGE : PCX.EXE  <FLENAME.PCX>");
   exit(1);
   }
Inp=fopen(argv[1],"rb");
memcpy(filename,argv[1],strlen(argv[1]));
memcpy(&filename[(strlen(argv[1]))-3],extension,strlen(extension));
Out=fopen(filename,"wb+");

scan_file();

t_init_13h();
ustaw_palete(Inp);

load_pcx(Inp);
getch();
t_close_13h();
fclose(Out);
extension[1]=0;          /* here we get the raw screen image and process it */
spawnlp(P_WAIT,"ELITE.EXE","!",&extension,&filename,NULL); /* with ELITE    */
Out=fopen(filename,"ab+");
fseek(Out,0,SEEK_END);
fwrite(paleta,1,768,Out);
fclose(Out);
fclose(Inp);
return 0;
}



scan_file()
{
char *matryca[12]={10,5,1,8,0,0,0,0,63,1,199,0};
char count=0;

while(count<12)
 {
 if(fgetc(Inp)!=(int)matryca[count])
    {
    printf("\n\rBad format or size 'pcx' file\n\r");
    exit(1);
    }
 count++;
 }
rewind(Inp);
koniec:                    /* END */
return 0;
}
